/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.mixin;

import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.api.PiglinNameManager;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5418;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5418.class})
public abstract class AbstractPiglinEntityMixin
extends class_1588
implements PiglinNameManager {
    private String firstName;
    private String lastName;
    private String fullName;
    private String playerName;

    public AbstractPiglinEntityMixin(class_1299<? extends class_5418> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public void setFirstName(String name) {
        this.firstName = name;
        this.updateFullName();
    }

    @Override
    public void setLastName(String name) {
        this.lastName = name;
        this.updateFullName();
    }

    @Override
    public void setPlayerName(String name) {
        this.playerName = name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void updateFullName() {
        StringBuilder builder = new StringBuilder();
        Objects.requireNonNull(this.firstName);
        if (VillagerNames.CONFIG.villagerGeneralConfig.piglinSurnames && this.lastName != null) {
            builder.append(this.firstName).append(" ").append(this.lastName);
        } else {
            builder.append(this.firstName);
        }
        this.fullName = builder.toString();
    }

    @Override
    public String getFullName() {
        if (this.playerName != null) {
            return this.playerName;
        }
        return this.fullName;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void serializeData(class_2487 tag, CallbackInfo ci) {
        if (this.firstName != null) {
            tag.method_10582("firstName", this.firstName);
        }
        if (this.fullName != null) {
            tag.method_10582("fullName", this.fullName);
        }
        if (this.lastName != null) {
            tag.method_10582("lastName", this.lastName);
        }
        if (this.playerName != null) {
            tag.method_10582("playerName", this.playerName);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void deserializeData(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("firstName")) {
            this.firstName = tag.method_10558("firstName");
        }
        if (tag.method_10545("fullName")) {
            this.fullName = tag.method_10558("fullName");
        }
        if (tag.method_10545("lastName")) {
            this.lastName = tag.method_10558("lastName");
        }
        if (tag.method_10545("playerName")) {
            this.playerName = tag.method_10558("playerName");
        }
    }
}

